# ComponentDoc Designer - 컴포넌트 사용 가이드

본 문서는 ComponentDoc Designer 디자인 시스템의 컴포넌트 사용법을 설명합니다.

---

## 1. 설치 (Installation)

빌드된 에셋(`dist/`)을 HTML에 포함하여 사용합니다.

```html
<!-- 필수: 스타일시트 -->
<link rel="stylesheet" href="./dist/style.css">

<!-- 선택: 인터랙션 기능 (아코디언, 코드 복사 등) -->
<script type="module" src="./dist/assets/interactive.js"></script>
```

### 권장 폰트

최적의 표시를 위해 다음 폰트를 함께 로드하세요:

```html
<!-- Pretendard (한글 본문) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/orioncactus/pretendard@v1.3.9/dist/web/static/pretendard.min.css" />

<!-- JetBrains Mono (코드 블록) -->
<link href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
```

### 기본 구조

모든 컴포넌트는 `.doc-system` 클래스 내부에서 사용합니다:

```html
<body class="doc-system">
  <!-- 컴포넌트들 -->
</body>
```

---

## 2. 컴포넌트 (Components)

### 2.1 버튼 (Buttons)

네비게이션 및 주요 작업에 사용되는 버튼입니다.

```html
<!-- Primary 버튼 (주요 액션) -->
<a href="#" class="nav-btn-primary">시작하기</a>

<!-- Secondary 버튼 (보조 액션) -->
<a href="#" class="nav-btn-secondary">문서 보기</a>

<!-- 버튼 그룹 -->
<div class="nav-btn-group">
  <a href="#" class="nav-btn-primary">시작하기</a>
  <a href="#" class="nav-btn-secondary">API 레퍼런스</a>
</div>
```

### 2.2 알림 (Alerts)

사용자에게 중요 정보를 전달할 때 사용합니다. 아이콘은 자동으로 표시됩니다.

```html
<div class="alert info">
  <strong>Info:</strong> 새로운 업데이트가 출시되었습니다.
</div>

<div class="alert success">
  <strong>Success:</strong> 변경사항이 저장되었습니다.
</div>

<div class="alert warning">
  <strong>Warning:</strong> 네트워크 연결이 불안정합니다.
</div>

<div class="alert error">
  <strong>Error:</strong> 파일 업로드 중 오류가 발생했습니다.
</div>
```

### 2.3 뱃지 (Badges)

상태나 카테고리를 표시하는 소형 라벨입니다.

```html
<span class="badge primary">New</span>
<span class="badge secondary">Beta</span>
<span class="badge outline">Experimental</span>
```

### 2.4 폼 컨트롤 (Form Controls)

#### Text Input & Textarea

```html
<div class="form-group">
  <label>이메일 주소</label>
  <input type="email" class="input-text" placeholder="name@example.com">
</div>

<div class="form-group">
  <label>메시지</label>
  <textarea class="textarea" placeholder="내용을 입력하세요..."></textarea>
</div>
```

#### Select Box

```html
<div class="form-group">
  <label>국가 선택</label>
  <select class="select-box">
    <option>국가를 선택하세요</option>
    <option>대한민국</option>
    <option>미국</option>
    <option>일본</option>
  </select>
</div>
```

#### Radio Buttons

라디오 버튼은 세 가지 필수 요소로 구성됩니다: `input`, `.radio-custom`, `.radio-label`

```html
<!-- 세로 정렬 -->
<div class="form-group">
  <label>플랜 선택</label>
  <div class="radio-list">
    <label class="radio-group">
      <input type="radio" name="plan" checked>
      <span class="radio-custom"></span>
      <span class="radio-label">Basic - 무료</span>
    </label>
    <label class="radio-group">
      <input type="radio" name="plan">
      <span class="radio-custom"></span>
      <span class="radio-label">Pro - ₩9,900/월</span>
    </label>
  </div>
</div>

<!-- 가로 정렬 -->
<div class="radio-list-horizontal">
  <label class="radio-group">
    <input type="radio" name="size" checked>
    <span class="radio-custom"></span>
    <span class="radio-label">Small</span>
  </label>
  <label class="radio-group">
    <input type="radio" name="size">
    <span class="radio-custom"></span>
    <span class="radio-label">Medium</span>
  </label>
  <label class="radio-group">
    <input type="radio" name="size">
    <span class="radio-custom"></span>
    <span class="radio-label">Large</span>
  </label>
</div>
```

#### Checkbox

체크박스도 세 가지 필수 요소로 구성됩니다: `input`, `.checkbox-custom`, `.checkbox-label`

```html
<!-- 세로 정렬 -->
<div class="form-group">
  <label>관심 분야 (복수 선택 가능)</label>
  <div class="checkbox-list">
    <label class="checkbox-group">
      <input type="checkbox" checked>
      <span class="checkbox-custom"></span>
      <span class="checkbox-label">프론트엔드 개발</span>
    </label>
    <label class="checkbox-group">
      <input type="checkbox">
      <span class="checkbox-custom"></span>
      <span class="checkbox-label">백엔드 개발</span>
    </label>
  </div>
</div>

<!-- 가로 정렬 -->
<div class="checkbox-list-horizontal">
  <label class="checkbox-group">
    <input type="checkbox" checked>
    <span class="checkbox-custom"></span>
    <span class="checkbox-label">React</span>
  </label>
  <label class="checkbox-group">
    <input type="checkbox">
    <span class="checkbox-custom"></span>
    <span class="checkbox-label">Vue</span>
  </label>
</div>

<!-- 단일 체크박스 -->
<label class="checkbox-group">
  <input type="checkbox">
  <span class="checkbox-custom"></span>
  <span class="checkbox-label">개인정보 수집 및 이용에 동의합니다.</span>
</label>
```

#### 비활성화 상태

`disabled` 속성을 추가하면 비활성화 스타일이 적용됩니다:

```html
<label class="radio-group">
  <input type="radio" name="demo" disabled>
  <span class="radio-custom"></span>
  <span class="radio-label">비활성화된 옵션</span>
</label>

<label class="checkbox-group">
  <input type="checkbox" checked disabled>
  <span class="checkbox-custom"></span>
  <span class="checkbox-label">선택된 비활성화 옵션</span>
</label>
```

### 2.5 아코디언 (Accordion)

FAQ나 상세 내용을 접고 펼칠 때 사용합니다. **`interactive.js` 로드 필요**

```html
<div class="accordion">
  <div class="accordion-item">
    <button class="accordion-header" aria-expanded="false">
      API Key는 어디서 발급받나요?
    </button>
    <div class="accordion-content">
      <div class="content-inner">
        설정 페이지의 'API 관리' 탭에서 새로운 키를 생성할 수 있습니다.
      </div>
    </div>
  </div>

  <div class="accordion-item">
    <button class="accordion-header" aria-expanded="false">
      요금제 변경은 어떻게 하나요?
    </button>
    <div class="accordion-content">
      <div class="content-inner">
        구독 관리 페이지에서 언제든지 요금제를 변경할 수 있습니다.
      </div>
    </div>
  </div>
</div>
```

### 2.6 코드 블록 (Code Blocks)

코드 예제를 표시할 때 사용합니다. 클릭하면 내용이 클립보드에 복사됩니다.

```html
<div class="code-block">
npm install @cf-ui/data-grid
</div>
```

### 2.7 테이블 (Tables)

데이터를 표 형식으로 표시합니다.

```html
<table>
  <thead>
    <tr>
      <th>속성명</th>
      <th>타입</th>
      <th>기본값</th>
      <th>설명</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><span class="prop-name">data</span></td>
      <td><span class="type-badge">Array</span></td>
      <td><span class="default-val">[]</span></td>
      <td>표시할 데이터 배열</td>
    </tr>
    <tr>
      <td><span class="prop-name">columns</span></td>
      <td><span class="type-badge">Column[]</span></td>
      <td><span class="default-val">undefined</span></td>
      <td>컬럼 정의 배열</td>
    </tr>
  </tbody>
</table>
```

### 2.8 예제 카드 (Example Cards)

컴포넌트 데모와 코드를 함께 보여줄 때 사용합니다.

```html
<div class="example-card">
  <div class="example-preview">
    <!-- 컴포넌트 미리보기 영역 -->
    <button class="nav-btn-primary">버튼 예제</button>
  </div>
  <div class="example-details">
    <h3>기본 버튼</h3>
    <p>가장 기본적인 형태의 버튼입니다.</p>
    <div class="code-block">
      &lt;button class="nav-btn-primary"&gt;버튼 예제&lt;/button&gt;
    </div>
  </div>
</div>
```

---

## 3. 레이아웃 (Layout)

### 섹션 구조

```html
<section>
  <h2>섹션 제목</h2>
  <p class="section-desc">섹션에 대한 설명 텍스트입니다.</p>

  <!-- 섹션 내용 -->
</section>
```

### 헤더 구조

```html
<header>
  <h1>컴포넌트 이름</h1>
  <span class="tag-name">&lt;component-tag&gt;</span>
  <p class="intro-p">컴포넌트에 대한 소개 문구입니다.</p>
  <div class="nav-btn-group">
    <a href="#" class="nav-btn-primary">시작하기</a>
    <a href="#" class="nav-btn-secondary">API 문서</a>
  </div>
</header>
```

---

## 4. 인터랙션 기능

`interactive.js`를 로드하면 다음 기능이 자동으로 활성화됩니다:

| 기능 | 설명 |
|------|------|
| **Accordion Toggle** | 아코디언 헤더 클릭 시 부드러운 확장/축소 애니메이션 |
| **Code Copy** | 코드 블록 클릭 시 내용을 클립보드에 복사 |
| **Smooth Scroll** | 앵커 링크(`#id`) 클릭 시 부드러운 스크롤 이동 |

---

## 5. 예제 페이지

전체 사용 예제는 `example/` 폴더에서 확인할 수 있습니다:

- `example/index.html` - 전체 컴포넌트 모음
- `example/forms.html` - 폼 컨트롤 상세 예제
- `sample/index.html` - 통합 샘플 페이지
